#include  "StdAfx.h"
#include  "TempBackupFile.hpp"
#include  <szFile.hpp>
#include  <szPath.hpp>
#include  <szRuntimeException.hpp>

using namespace szpp;

TempBackupFile::TempBackupFile(const szstring &path) : originalPath(path), backupPath()
{
  if (FileExists(originalPath))
  {
    const szstring tempFileName = CreateTempFileName(ExtractDirectory(originalPath));
    if (!FileExists(tempFileName) || 0 != DeleteFile(tempFileName.c_str()))
    {
      backupPath = tempFileName;
      if (0 == MoveFile(originalPath.c_str(), backupPath.c_str()))
        BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot rename the existing file")) << last_error_info(GetLastError()));
    }
  }
}

TempBackupFile::~TempBackupFile()
{
  if (!backupPath.empty())
    DeleteFile(backupPath.c_str());
}

void TempBackupFile::Rollback()
{
  if (!backupPath.empty())
  {
    MoveFile(backupPath.c_str(), originalPath.c_str());
    backupPath.clear();
  }
}
